// Mock data for Castanhal Tracking website

export const companyInfo = {
  name: "Castanhal Tracking",
  fullName: "Castanhal Tracking Rastreamento Veicular",
  whatsapp: "(91) 99335-2733",
  whatsappLink: "https://wa.me/5591993352733",
  instagram: "https://www.instagram.com/castanhal_rastreamento",
  instagramHandle: "@castanhal_rastreamento",
  location: "Belém do Pará e Região Metropolitana",
  monthlyPrice: 50.00,
  logo: "https://customer-assets.emergentagent.com/job_6302ac37-6d96-43e8-b5ef-587e207e75f2/artifacts/kjna5bnm_logo-rastreamento-veicular-tech2.png"
};

export const vehicleTypes = [
  { id: 1, name: "Carro", icon: "Car" },
  { id: 2, name: "Moto", icon: "Bike" },
  { id: 3, name: "Caminhão", icon: "Truck" }
];

export const features = [
  {
    id: 1,
    title: "Localização em Tempo Real",
    description: "Acompanhe seu veículo 24 horas por dia, 7 dias por semana, com precisão GPS de alta qualidade.",
    icon: "MapPin"
  },
  {
    id: 2,
    title: "Bloqueio Remoto",
    description: "Bloqueie seu veículo instantaneamente pelo aplicativo em caso de roubo ou furto.",
    icon: "Lock"
  },
  {
    id: 3,
    title: "Cercas Virtuais",
    description: "Crie áreas de segurança e receba alertas quando seu veículo entrar ou sair dessas regiões.",
    icon: "Shield"
  },
  {
    id: 4,
    title: "Alertas de Velocidade",
    description: "Configure limites de velocidade e seja notificado quando forem ultrapassados.",
    icon: "Gauge"
  },
  {
    id: 5,
    title: "Histórico de 180 Dias",
    description: "Acesse relatórios completos com todo o trajeto do seu veículo nos últimos 6 meses.",
    icon: "History"
  },
  {
    id: 6,
    title: "Alertas de Bateria",
    description: "Receba notificações sobre o nível de bateria do rastreador e do veículo.",
    icon: "BatteryCharging"
  }
];

export const benefits = [
  {
    id: 1,
    title: "Equipamento Gratuito",
    description: "Você não paga nada pelo equipamento, oferecemos em regime de comodato.",
    icon: "Gift"
  },
  {
    id: 2,
    title: "Sem Fidelidade",
    description: "Sem contrato de fidelidade, cancele quando quiser sem multas.",
    icon: "Unlock"
  },
  {
    id: 3,
    title: "Instalação a Domicílio",
    description: "Agendamos a instalação no local de sua preferência, sem você sair de casa.",
    icon: "Home"
  },
  {
    id: 4,
    title: "Sem Burocracia",
    description: "Processo simples e rápido, sem papelada ou complicações.",
    icon: "Zap"
  }
];

export const testimonials = [
  {
    id: 1,
    name: "Carlos Silva",
    vehicle: "Carro",
    text: "Excelente serviço! Recuperei meu carro em menos de 2 horas após o furto graças ao rastreamento.",
    rating: 5
  },
  {
    id: 2,
    name: "Maria Santos",
    vehicle: "Moto",
    text: "O aplicativo é muito fácil de usar. Acompanho minha moto em tempo real e fico tranquila.",
    rating: 5
  },
  {
    id: 3,
    name: "João Pereira",
    vehicle: "Caminhão",
    text: "Para minha frota de caminhões, o serviço é indispensável. Controle total das rotas e economia de combustível.",
    rating: 5
  }
];

export const faqs = [
  {
    question: "Como funciona a instalação?",
    answer: "A instalação é feita a domicílio por técnicos especializados. Basta agendar um horário pelo WhatsApp e iremos até você."
  },
  {
    question: "Preciso pagar pelo equipamento?",
    answer: "Não! O equipamento é fornecido em regime de comodato, ou seja, você não paga nada por ele."
  },
  {
    question: "Existe contrato de fidelidade?",
    answer: "Não existe contrato de fidelidade. Você pode cancelar o serviço a qualquer momento sem multas."
  },
  {
    question: "Qual a área de cobertura?",
    answer: "Atendemos Belém do Pará e toda a Região Metropolitana com instalação a domicílio."
  },
  {
    question: "O rastreador funciona em todo o Brasil?",
    answer: "Sim! Uma vez instalado, o rastreador funciona em todo território nacional com cobertura de sinal."
  },
  {
    question: "Como faço para bloquear meu veículo?",
    answer: "Através do nosso aplicativo, você pode bloquear seu veículo com apenas um toque na tela."
  }
];

export const steps = [
  {
    number: "01",
    title: "Entre em Contato",
    description: "Fale conosco pelo WhatsApp e tire suas dúvidas."
  },
  {
    number: "02",
    title: "Agende a Instalação",
    description: "Escolha o melhor dia e horário para a instalação."
  },
  {
    number: "03",
    title: "Instalação a Domicílio",
    description: "Nosso técnico vai até você e instala o rastreador."
  },
  {
    number: "04",
    title: "Pronto para Usar",
    description: "Baixe o app e comece a rastrear seu veículo."
  }
];
