import React from 'react';
import { Phone, MapPin, Instagram } from 'lucide-react';
import { companyInfo } from '../data/mock';

const Footer = () => {
  const currentYear = new Date().getFullYear();

  const quickLinks = [
    { name: 'Início', href: '#inicio' },
    { name: 'Recursos', href: '#recursos' },
    { name: 'Benefícios', href: '#beneficios' },
    { name: 'Como Funciona', href: '#como-funciona' },
    { name: 'FAQ', href: '#faq' },
  ];

  return (
    <footer className="bg-[var(--bg-secondary)] border-t border-[var(--border-subtle)] pt-16 pb-8">
      <div className="container mx-auto px-6">
        <div className="grid md:grid-cols-2 lg:grid-cols-4 gap-12 mb-12">
          {/* Brand */}
          <div className="lg:col-span-2">
            <a href="#inicio" className="inline-block mb-4">
              <img
                src={companyInfo.logo}
                alt={companyInfo.name}
                className="h-16 w-auto"
              />
            </a>
            <p className="text-[var(--text-muted)] mb-6 max-w-md">
              Rastreamento veicular com tecnologia de ponta para carros, motos e caminhões. 
              Proteção completa para seu veículo em {companyInfo.location}.
            </p>
            <div className="flex gap-4">
              <a
                href={companyInfo.whatsappLink}
                target="_blank"
                rel="noopener noreferrer"
                className="w-10 h-10 rounded-lg bg-[var(--bg-tertiary)] flex items-center justify-center text-[var(--text-muted)] hover:bg-[var(--accent-primary)] hover:text-[var(--bg-primary)] transition-all duration-200"
              >
                <Phone size={20} />
              </a>
              <a
                href={companyInfo.instagram}
                target="_blank"
                rel="noopener noreferrer"
                className="w-10 h-10 rounded-lg bg-[var(--bg-tertiary)] flex items-center justify-center text-[var(--text-muted)] hover:bg-[var(--accent-primary)] hover:text-[var(--bg-primary)] transition-all duration-200"
              >
                <Instagram size={20} />
              </a>
            </div>
          </div>

          {/* Quick Links */}
          <div>
            <h3 className="text-lg font-semibold mb-4">Links Rápidos</h3>
            <ul className="space-y-3">
              {quickLinks.map((link) => (
                <li key={link.name}>
                  <a
                    href={link.href}
                    className="text-[var(--text-muted)] hover:text-[var(--accent-primary)] transition-colors duration-200"
                  >
                    {link.name}
                  </a>
                </li>
              ))}
            </ul>
          </div>

          {/* Contact */}
          <div>
            <h3 className="text-lg font-semibold mb-4">Contato</h3>
            <ul className="space-y-4">
              <li>
                <a
                  href={companyInfo.whatsappLink}
                  target="_blank"
                  rel="noopener noreferrer"
                  className="flex items-center gap-3 text-[var(--text-muted)] hover:text-[var(--accent-primary)] transition-colors duration-200"
                >
                  <Phone size={18} className="text-[var(--accent-primary)]" />
                  {companyInfo.whatsapp}
                </a>
              </li>
              <li>
                <a
                  href={companyInfo.instagram}
                  target="_blank"
                  rel="noopener noreferrer"
                  className="flex items-center gap-3 text-[var(--text-muted)] hover:text-[var(--accent-primary)] transition-colors duration-200"
                >
                  <Instagram size={18} className="text-[var(--accent-primary)]" />
                  {companyInfo.instagramHandle}
                </a>
              </li>
              <li className="flex items-start gap-3 text-[var(--text-muted)]">
                <MapPin size={18} className="text-[var(--accent-primary)] mt-1 flex-shrink-0" />
                <span>{companyInfo.location}</span>
              </li>
            </ul>
          </div>
        </div>

        {/* Bottom Bar */}
        <div className="border-t border-[var(--border-subtle)] pt-8">
          <div className="flex flex-col md:flex-row justify-between items-center gap-4">
            <p className="text-[var(--text-muted)] text-sm">
              © {currentYear} {companyInfo.fullName}. Todos os direitos reservados.
            </p>
            <div className="flex items-center gap-6">
              <span className="text-[var(--text-muted)] text-sm">
                Instalação a domicílio • Sem fidelidade • Equipamento gratuito
              </span>
            </div>
          </div>
        </div>
      </div>
    </footer>
  );
};

export default Footer;
