import React from 'react';
import { motion } from 'framer-motion';
import { useInView } from 'react-intersection-observer';
import { faqs } from '../data/mock';
import {
  Accordion,
  AccordionContent,
  AccordionItem,
  AccordionTrigger,
} from './ui/accordion';

const FAQ = () => {
  const [ref, inView] = useInView({
    triggerOnce: true,
    threshold: 0.1,
  });

  return (
    <section id="faq" className="py-24 relative">
      {/* Background */}
      <div className="absolute inset-0 bg-[var(--bg-secondary)]" />
      
      <div className="container mx-auto px-6 relative z-10">
        <motion.div
          ref={ref}
          initial={{ opacity: 0, y: 30 }}
          animate={inView ? { opacity: 1, y: 0 } : {}}
          transition={{ duration: 0.6 }}
          className="text-center mb-16"
        >
          <span className="text-[var(--accent-primary)] text-sm font-semibold uppercase tracking-wider mb-4 block">
            Dúvidas Frequentes
          </span>
          <h2 className="section-title">
            Perguntas{' '}
            <span className="text-neon">Frequentes</span>
          </h2>
          <p className="section-subtitle mt-4">
            Tire suas dúvidas sobre nossos serviços
          </p>
        </motion.div>

        <motion.div
          initial={{ opacity: 0, y: 30 }}
          animate={inView ? { opacity: 1, y: 0 } : {}}
          transition={{ duration: 0.6, delay: 0.2 }}
          className="max-w-3xl mx-auto"
        >
          <Accordion type="single" collapsible className="space-y-4">
            {faqs.map((faq, index) => (
              <AccordionItem
                key={index}
                value={`item-${index}`}
                className="bg-[var(--bg-tertiary)] border border-[var(--border-subtle)] rounded-xl px-6 data-[state=open]:border-[var(--accent-primary)] transition-colors duration-300"
              >
                <AccordionTrigger className="text-left py-5 hover:no-underline text-[var(--text-primary)] font-medium hover:text-[var(--accent-primary)] transition-colors">
                  {faq.question}
                </AccordionTrigger>
                <AccordionContent className="text-[var(--text-muted)] pb-5 leading-relaxed">
                  {faq.answer}
                </AccordionContent>
              </AccordionItem>
            ))}
          </Accordion>
        </motion.div>
      </div>
    </section>
  );
};

export default FAQ;
