import React from 'react';
import { motion } from 'framer-motion';
import { useInView } from 'react-intersection-observer';
import { Phone, ArrowRight } from 'lucide-react';
import { companyInfo } from '../data/mock';

const CTA = () => {
  const [ref, inView] = useInView({
    triggerOnce: true,
    threshold: 0.1,
  });

  return (
    <section className="py-24 relative overflow-hidden">
      {/* Background */}
      <div className="absolute inset-0">
        <div className="absolute inset-0 bg-gradient-to-r from-[var(--bg-primary)] via-[var(--bg-secondary)] to-[var(--bg-primary)]" />
        {/* Neon Glow */}
        <div className="absolute top-1/2 left-1/2 transform -translate-x-1/2 -translate-y-1/2 w-[600px] h-[300px] bg-[var(--accent-primary)] opacity-[0.08] rounded-full blur-[100px]" />
      </div>
      
      <div className="container mx-auto px-6 relative z-10">
        <motion.div
          ref={ref}
          initial={{ opacity: 0, scale: 0.95 }}
          animate={inView ? { opacity: 1, scale: 1 } : {}}
          transition={{ duration: 0.6 }}
          className="bg-[var(--bg-secondary)] border border-[var(--border-subtle)] rounded-3xl p-8 md:p-12 text-center relative overflow-hidden"
        >
          {/* Decorative Elements */}
          <div className="absolute top-0 left-0 w-32 h-32 bg-[var(--accent-primary)] opacity-10 rounded-full blur-[60px]" />
          <div className="absolute bottom-0 right-0 w-32 h-32 bg-[var(--accent-cyan)] opacity-10 rounded-full blur-[60px]" />
          
          <div className="relative z-10">
            <span className="inline-flex items-center gap-2 px-4 py-2 rounded-full bg-[var(--accent-bg)] border border-[var(--accent-primary)] mb-6">
              <Phone size={18} className="text-[var(--accent-primary)]" />
              <span className="text-[var(--accent-primary)] text-sm font-medium">
                {companyInfo.whatsapp}
              </span>
            </span>
            
            <h2 className="text-3xl md:text-4xl lg:text-5xl font-bold mb-6">
              Pronto para{' '}
              <span className="text-neon">proteger</span> seu veículo?
            </h2>
            
            <p className="text-[var(--text-secondary)] text-lg mb-8 max-w-2xl mx-auto">
              Entre em contato agora mesmo e agende sua instalação. 
              Equipamento gratuito, sem fidelidade e a partir de R$ {companyInfo.monthlyPrice}/mês.
            </p>
            
            <div className="flex flex-wrap justify-center gap-4">
              <a
                href={companyInfo.whatsappLink}
                target="_blank"
                rel="noopener noreferrer"
                className="btn-primary animate-pulse-glow"
              >
                Falar pelo WhatsApp
                <ArrowRight size={20} />
              </a>
              <a
                href={companyInfo.instagram}
                target="_blank"
                rel="noopener noreferrer"
                className="btn-secondary"
              >
                Seguir no Instagram
              </a>
            </div>
          </div>
        </motion.div>
      </div>
    </section>
  );
};

export default CTA;
