import React from 'react';
import { motion } from 'framer-motion';
import { useInView } from 'react-intersection-observer';
import { Gift, Unlock, Home, Zap, Check, ArrowRight } from 'lucide-react';
import { benefits, companyInfo } from '../data/mock';

const iconMap = {
  Gift,
  Unlock,
  Home,
  Zap,
};

const Benefits = () => {
  const [ref, inView] = useInView({
    triggerOnce: true,
    threshold: 0.1,
  });

  return (
    <section id="beneficios" className="py-24 relative overflow-hidden">
      {/* Background Effects */}
      <div className="absolute top-0 right-0 w-[500px] h-[500px] bg-[var(--accent-primary)] opacity-[0.03] rounded-full blur-[150px]" />
      
      <div className="container mx-auto px-6 relative z-10">
        <div className="grid lg:grid-cols-2 gap-16 items-center">
          {/* Left Content */}
          <motion.div
            ref={ref}
            initial={{ opacity: 0, x: -50 }}
            animate={inView ? { opacity: 1, x: 0 } : {}}
            transition={{ duration: 0.6 }}
          >
            <span className="text-[var(--accent-primary)] text-sm font-semibold uppercase tracking-wider mb-4 block">
              Vantagens Exclusivas
            </span>
            <h2 className="section-title mb-6">
              Por que escolher a{' '}
              <span className="text-neon">Castanhal Tracking</span>?
            </h2>
            <p className="text-[var(--text-secondary)] text-lg mb-8">
              Oferecemos o melhor custo-benefício do mercado, sem complicações 
              e com atendimento personalizado.
            </p>

            {/* Price Card */}
            <div className="bg-[var(--bg-secondary)] border border-[var(--border-subtle)] rounded-2xl p-6 mb-8">
              <div className="flex items-center justify-between mb-4">
                <span className="text-[var(--text-muted)]">Mensalidade</span>
                <div className="flex items-baseline gap-1">
                  <span className="text-3xl font-bold text-neon">R$ {companyInfo.monthlyPrice}</span>
                  <span className="text-[var(--text-muted)]">/mês</span>
                </div>
              </div>
              <div className="space-y-3">
                <div className="flex items-center gap-3">
                  <Check size={18} className="text-[var(--accent-primary)]" />
                  <span className="text-[var(--text-secondary)]">Equipamento em comodato (gratuito)</span>
                </div>
                <div className="flex items-center gap-3">
                  <Check size={18} className="text-[var(--accent-primary)]" />
                  <span className="text-[var(--text-secondary)]">Instalação a domicílio inclusa</span>
                </div>
                <div className="flex items-center gap-3">
                  <Check size={18} className="text-[var(--accent-primary)]" />
                  <span className="text-[var(--text-secondary)]">Sem contrato de fidelidade</span>
                </div>
              </div>
            </div>

            <a
              href={companyInfo.whatsappLink}
              target="_blank"
              rel="noopener noreferrer"
              className="btn-primary inline-flex"
            >
              Contratar Agora
              <ArrowRight size={20} />
            </a>
          </motion.div>

          {/* Right Content - Benefits Grid */}
          <div className="grid sm:grid-cols-2 gap-6">
            {benefits.map((benefit, index) => {
              const Icon = iconMap[benefit.icon];
              return (
                <motion.div
                  key={benefit.id}
                  initial={{ opacity: 0, y: 30 }}
                  animate={inView ? { opacity: 1, y: 0 } : {}}
                  transition={{ duration: 0.5, delay: index * 0.15 }}
                  className="bg-[var(--bg-secondary)] border border-[var(--border-subtle)] rounded-2xl p-6 hover:border-[var(--accent-primary)] transition-all duration-300 group"
                >
                  <div className="w-14 h-14 rounded-xl bg-[var(--accent-bg)] flex items-center justify-center mb-4 group-hover:scale-110 transition-transform duration-300">
                    <Icon size={28} className="text-[var(--accent-primary)]" />
                  </div>
                  <h3 className="text-lg font-semibold mb-2">{benefit.title}</h3>
                  <p className="text-[var(--text-muted)] text-sm leading-relaxed">
                    {benefit.description}
                  </p>
                </motion.div>
              );
            })}
          </div>
        </div>
      </div>
    </section>
  );
};

export default Benefits;
